#pragma once

#include <vector>
using std::vector;

class GameObject;

class Quadtree {

enum Node {
	NW = 0,
	NE,
	SW,
	SE,
	NodeCount
};

public:
	Quadtree();

	Quadtree( double left, double right, double top, double down, unsigned int numObjectsToGrow = 3 );

	~Quadtree();

	void AddObject( GameObject *object );

	void Clear();

	vector<GameObject*> GetObjectsAt( double x, double y );

	void draw();

	double returnRect(int i);

private:
	double left;

	double right;

	double top;

	double down;

	unsigned int numObjectsToGrow;

	vector<GameObject*> objects;

	Quadtree *nodes;

	bool isLeaf;
	
	bool contains( GameObject *object );
	
	bool contains( double x, double y );

	void createLeaves();

	void moveObjectsToLeaves();
	
};